/********************************************************************
 * Support functions for PTZ control, button states and parameters  *
*********************************************************************/
 

/**
 * Set the state of all memory buttons.
 */
function setMemStates(mem, state, restState) {
  for (let i = 1; i <= numberOfMemButtons; i++) {
    const memButton = document.querySelector(`#ptz_mem${i}`);
    if (!memButton) continue;
      if (i === mem) {
        memButton.setAttribute("src", `svg/mem${i}_${state}.svg`);
      } else {
         memButton.setAttribute("src", `svg/mem${i}_${restState}.svg`);    
      }
  }
}

/**
 * Set the state of zoom buttons.
 */
function setZoomStates(stateIn, stateOut) {
  const zoomIn = document.querySelector("#ptz_zoom_in");
  const zoomOut = document.querySelector("#ptz_zoom_out");
  if (zoomIn) zoomIn.setAttribute("src", `svg/zoom_in_${stateIn}.svg`);
  if (zoomOut) zoomOut.setAttribute("src", `svg/zoom_out_${stateOut}.svg`);
}

/**
 * Set the state of the save button.
 */
function setSaveState(state) {
  const saveButton = document.querySelector("#ptz_mem_save");
  if (saveButton) saveButton.setAttribute("src", `svg/mem_save_${state}.svg`);
}

/**
 * Set the state of the close button.
 */
function setCloseState(state) {
  const closeButton = document.querySelector("#close_button");
  if (closeButton) closeButton.setAttribute("src", `svg/close_${state}.svg`);
}
 
function setSaveState(state) {
  const saveButton = document.querySelector("#ptz_mem_save");
  if (saveButton) saveButton.setAttribute("src", `svg/mem_save_${state}.svg`);
}

/**
 * Set the state of a single memory button.
 */
function setMemState(mem, state) {
  const memButton = document.querySelector(`#ptz_mem${mem}`);
  if (memButton) memButton.setAttribute("src", `svg/mem${mem}_${state}.svg`);
}

/**
 * Get the memory button ID from an event.
 */
function getMemId(event) {
  const target = event.target || event.srcElement;
  return Number(target.id.replace("ptz_mem", ""));
}


function stopPropagation(event) {
  event.preventDefault();
  event.stopImmediatePropagation();
}

/**
 * decode the url parameters into a key value object
 */
function getParams() {
  const params = {};
  const searchParams = new URLSearchParams(window.location.search);
  for (const [key, value] of searchParams.entries()) {
    params[key] = value;
  }
  return params;
}


/**
 * Calculate relative movement based on mouse event.
 */
function calcMovement(event) {
  const videoElement = document.querySelector("#video");
  if (!videoElement) return;
  const rect = videoElement.getBoundingClientRect();
  const x = event.clientX - rect.left; // x position within the element.
  const y = event.clientY - rect.top;  // y position within the element.
  rx = (x - (videoElement.width / 2)) / videoElement.width;
  ry = -((y - (videoElement.height / 2)) / videoElement.height);
  setDragLine(x,y); // initialize drag line
}

/**
 * draw or clear the drag line from center to mouse position
 */
function setDragLine(x2, y2) {
  const dragLine = document.getElementById("ptz_dragline");
  if (!dragLine) return;
  if (!indrag) {
    dragLine.innerHTML = "";
    return;
  }
  const videoElement = document.querySelector("#video");
  if (!videoElement) return;
  const x1 = videoElement.width / 2;
  const y1 = videoElement.height / 2;
  dragLine.innerHTML = `
    <svg id="ptz_dragline_svg" xmlns="http://www.w3.org/2000/svg">
      <line x1="${x1}" y1="${y1}" x2="${x2}" y2="${y2}" stroke="white" stroke-opacity="0.8" stroke-width="2" />
    </svg>
  `;
}


/**
 * Update PTZ position if dragging usng rx and ry values
 */
function updatePtzPosition() {
  if (indrag) {
    setCamCmd(`${PTZ_MOVE}${rx * xspeed},${ry * yspeed}`);
    saveDelay++;
    if (saveDelay > 1) {
      canSave = true;
      setSaveState(MEM_CAN_SAVE);
      setMemStates(selectedMem, MEM_RELOAD, MEM_UNSELECTED);
    }
  }
}

/**
 * Send a PTZ command to the camera.
 */
function setCamCmd(command) {
  const url = `http://${params["control"]}/axis-cgi/com/ptz.cgi?camera=1&${command}`;
  fetch(url)
    .then(response => {
      if (!response.ok) throw new Error('Network response was not ok ' + response.statusText);
      return response.text();
    })
    .catch(error => {
      console.error('PTZ command fetch error:', error);
    });
}